package control;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.JDialog;
import javax.swing.JLabel;

import model.Board;
import model.MineException;

public class BoardController implements MouseListener{

	private Board board;

	public BoardController(Board board) {
		super();
		this.board = board;
	}

	@Override
	public void mouseClicked(MouseEvent arg0) {
			if (arg0.isMetaDown()) {
				board.markBox(mouse2PixelIndex(arg0.getX()), mouse2PixelIndex(arg0.getY()));
				System.out.println("bab");
				return;
			}
			try {
				board.selectBox(mouse2PixelIndex(arg0.getX()), mouse2PixelIndex(arg0.getY()));
			} catch (MineException e) {
				JDialog dialog = new JDialog();
				dialog.setVisible(true);
				dialog.setTitle("Error");
				dialog.add(new JLabel("Hai perso"));
				dialog.setDefaultCloseOperation(JDialog.EXIT_ON_CLOSE);
			}		
	}

	private int mouse2PixelIndex(int mousePosition) {
		return mousePosition / 30;
	}

	@Override
	public void mouseEntered(MouseEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void mouseExited(MouseEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void mousePressed(MouseEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void mouseReleased(MouseEvent arg0) {
		// TODO Auto-generated method stub
		
	}

}
